# Cawl Online Payments

**Payment methods**

Our plugin supports from the most global to very local payment methods to support business all over the world:

- **Credit and debit cards:** Visa, Mastercard, American Express, Carte Bancaire, Diners, JCB, Maestro, Union Pay International
- **Mobile payment methods:** Alipay+, Apple Pay, Google Pay, WeChatPay
- **Buy Now Pay Later:** Klarna, Oney 3x-4x, Oney Financement Long,
- **Alternative payment methods:** iDEAL, Bancontact, PayPal, Bizum, Cpay, Multibanco, Przelewy24, Twint, EPS, Bank Transfer by Cawl
- **Giftcards:** Intersolve gift cards, OneyBrandedGiftCard, Illicado, Giftcard Limonetik

**Process high-conversion payments**

Our Magento plugin makes use of our latest set of API, built specifically to ensure a high conversion rate for anyone using them:

- **Lightning mode:** Simply configure your credentials, and you’re ready to go!
- **Remember me:** use the native vault functionality from Magento to save your customers payment details and facilitate the
  journey of returning customers
- **Auto-format card number:** our payment page ensures that the card number is easily readable by any consumer using it
- **Automatic brand detection:** automatically detect the brand of the card used to avoid any error during the payment
  process.
- **Adaptative keyboard:** display the right keyboard on the right field on the payment page
- **28 supported languages** for the payment page
- **Compatible with advanced fraud solutions:** our plugin is fully compatible with the Cawl fraud solution. Build up your
  custom rules to ensure any legitimate transaction can go through, and block any fraudulent transaction.
- **Fully customizable payment pages:** the payment page is fully customizable through a powerful template builder allowing
  you to have access to both HTML and CSS of the payment page to fully blend in your own website style.
- **Authorize now, capture later:** we support separate authorization and capture, allowing you to manage the payment after
  the shipping while making sure all the necessary checks are performed on the card. We even support pre-authorization for
  sectors that need it!
- **Mobile first experience:** our solution is built to be fully responsive and will adapt to any device the customers may use.

**Provide the best checkout experience**

We made sure your customers remains as long as possible on your website and can retry seamlessly in case of a failed attempt, and
that at any time your Magento is fully up to date with the latest payment information

- **Basket is kept when clicking on “back”:** what is more frustrating that losing your basket when you click on “back” in your
  browser? Our plugin offers a native solution for this problematic!
- **Dynamic feedback:** our plugin will listen to feedback from Cawl to update the transaction status, while
  actively questioning the payment system to make sure no discrepancy occurs on your platform.
- **Submit basket details to the payment page:** on top of providing a best-in-class customer experience, this will also enable
  some specific payment methods like Klarna on your checkout page. The order data from the cart will be displayed on the
  Cawl Payment Page for enhanced buyer experience.
- **Integrate directly with our PWA extension:** we have also made available a Magento PWA extension that will help you build your storefront as easily as possible and introduce you to headless commerce.

**Follow up your transactions**

On top of allowing you to process successful transactions, our plugin will also provide you the tools needed to follow up failed
transactions and take actions accordingly

- **Customizable statuses:** even though we implemented the out-of-the-box Magento native flows, our plugin allow further
  customization to ensure the payments follow your flows and are adapted to any kind of business.
- **Manage maintenance operations:** our plugin allows you to easily maintain your transactions directly from the Magento
  Admin panel, making sure you can process multiple and partial captures and refunds directly from the native Magento
  interface.
- **Advanced logging system:** we have developed an advanced logging system that will allow you to easily retrieve all logs
  related to a specific transaction whenever you need it. This will allow you to further analyze your conversion numbers, and
  take enlightened business decisions accordingly.

## Main Extension for Adobe Commerce with all cawl solutions 

[![M2 Coding Standard](https://github.com/Worldline-Plugins/cawl-plugin-magento/actions/workflows/coding-standard.yml/badge.svg?branch=develop)](https://github.com/Worldline-Plugins/cawl-plugin-magento/actions/workflows/coding-standard.yml)
[![M2 Mess Detector](https://github.com/Worldline-Plugins/cawl-plugin-magento/actions/workflows/mess-detector.yml/badge.svg?branch=develop)](https://github.com/Worldline-Plugins/cawl-plugin-magento/actions/workflows/mess-detector.yml)

This is a main module that are used as a container to get all Cawl payment solutions:
- [credit card](https://github.com/Worldline-Plugins/cawl-plugin-magento-creditcard)
- [hosted checkout](https://github.com/Worldline-Plugins/cawl-plugin-magento-hostedcheckout)
- [redirect payments (single payment buttons)](https://github.com/Worldline-Plugins/cawl-plugin-magento-redirect-payments)

## Installation
To install the extensions, follow these steps in the root of your Magento installation:

### Specify target repositories
````
composer config repositories.cawl/module-magento-payment git git@github.com:Worldline-Plugins/cawl-plugin-magento.git

composer config repositories.cawl/module-magento-payment-core git git@github.com:Worldline-Plugins/cawl-plugin-magento-core.git

composer config repositories.cawl/module-magento-payment-hostedcheckout git git@github.com:Worldline-Plugins/cawl-plugin-magento-hostedcheckout.git

composer config repositories.cawl/module-magento-payment-redirectpayment git git@github.com:Worldline-Plugins/cawl-plugin-magento-redirect-payments.git

composer config repositories.cawl/module-magento-payment-creditcard git git@github.com:Worldline-Plugins/cawl-plugin-magento-creditcard.git

composer config repositories.cawl/module-magento-payment-graph-ql git git@github.com:Worldline-Plugins/cawl-plugin-magento-graph-ql.git
````

### Execute the composer command to install the packages
````
composer require cawl/module-magento-payment
````

### Execute magento commands to complete installation:
``````
bin/magento setup:upgrade

bin/magento setup:di:compile

bin/magento setup:static-content:deploy
``````

### Change log:

#### 1.1.17
- Fix print invoice issue
- Update payment brand logos

#### 1.1.16
- Allow Order Creation on Amount Discrepancies

#### 1.1.15
- Add quote ID to request payload
- Fix wrong IP address being sent on checkout
- Decrease maximum payment method logos
- Add compatibility with 2.4.8-p2

#### 1.1.14
- Fix issue with sending email

#### 1.1.13
- Fix wrong handling of payment specific information on order page

#### 1.1.12
- Fix comma separated email validation in notification settings

#### 1.1.11
- Fix issue with showing split payment amounts on order details page for Mealvoucher transactions
- Fix issue with showing Mealvoucher in full redirect

#### 1.1.10
- Fix logo issue for CB on checkout page
- Fix PHP >= 8.2 issue with not sending parameter by reference

#### 1.1.9
- Add Mealvoucher payment product
- Add CVCO (Cheque Vacances Connect Online) payment product

#### 1.1.8
- Add compatibility with PHP 8.4
- Update SDK version

#### 1.1.7
- Fixed issue with default 3DS values (update the credit-card, graph-ql and redirect-payment modules)

#### 1.1.6
- Fixed failed payment log table name (update the credit-card, graph-ql and redirect-payment modules)

#### 1.1.5
- Update plugin translations

#### 1.1.4
- Add 3DS exemption types to the plugin

#### 1.1.3
- Update the credit-card, graph-ql and redirect-payment CAWL modules

#### 1.1.2
- Update the credit-card and graph-ql and redirect-payment CAWL modules

#### 1.1.1
- Update the graph-ql and redirect-payment CAWL modules

#### 1.1.0
- Fixed validation for HTML template ID configuration. It is no longer required to have extension on HTML templates.
- Fixed issue where items quantities in decimals were not taken into account.
- Improved handling of orders where the total amount does not match the sum of line items amount due to the rounding.

#### 1.0.0
- Initial MVP version.
