<?php

declare (strict_types=1);
namespace Syde\Vendor\Cawl;

// phpcs:disable Inpsyde.CodeQuality.LineLength.TooLong
use Syde\Vendor\Cawl\Dhii\Services\Factory;
use Syde\Vendor\Cawl\Inpsyde\WorldlineForWoocommerce\Config\CancellationIntervals;
use Syde\Vendor\Cawl\Inpsyde\WorldlineForWoocommerce\Config\CaptureMode;
use Syde\Vendor\Cawl\Inpsyde\WorldlineForWoocommerce\WorldlinePaymentGateway\ThreeDSecure\ExemptionType;
return new Factory(['webhooks.settings.fields', 'worldline_payment_gateway.api.default_test_endpoint', 'worldline_payment_gateway.api.default_live_endpoint', 'core.live_create_account_url', 'uninstall.db-cleaner-url'], static function (array $webhookFields, string $defaultTestEndpoint, string $defaultLiveEndpoint, string $liveCreateAccountUrl, string $dbCleanerUrl) : array {
    $config = (require __DIR__ . '/../../../../config.php');
    $defaultLogoUrl = \plugin_dir_url(__DIR__ . '/../../../../../') . 'modules/inpsyde/worldline-payment-gateway/assets/images/worldline-logo.svg';
    $apiFields = ['pspid' => ['title' => \__('PSPID', 'cawl-for-woocommerce'), 'type' => 'text', 'description' => \__('Enter your Merchant ID or your CAWL Login Name.', 'cawl-for-woocommerce'), 'desc_tip' => \true], 'live_mode' => ['title' => \__('Live mode', 'cawl-for-woocommerce'), 'type' => 'checkbox', 'label' => \__('Use the live environment', 'cawl-for-woocommerce'), 'default' => 'no'], 'live_account_note' => ['type' => 'content', 'description' => \sprintf(
        // translators: %1$s, %2$s - <a> link tags.
        \__('For creating a live account, please %1$scontact the sales team%2$s.', 'cawl-for-woocommerce'),
        '<a id="wlopLiveAccountNote" target="_blank" href="' . \esc_url($liveCreateAccountUrl) . '">',
        '</a>'
    )], 'test_api_key' => ['title' => \__('Test API Key', 'cawl-for-woocommerce'), 'type' => 'text', 'description' => \__('Find/create the API Key in Developer tab > Payment API on your CAWL Merchant Portal Dashboard (Test).', 'cawl-for-woocommerce'), 'desc_tip' => \true, 'custom_attributes' => ['autocomplete' => 'off']], 'test_api_secret' => ['title' => \__('Test API Secret', 'cawl-for-woocommerce'), 'type' => 'password', 'description' => \__('Find/create the API Secret in the Developer tab > Payment API on your CAWL Merchant Portal Dashboard (Test).', 'cawl-for-woocommerce'), 'desc_tip' => \true, 'custom_attributes' => ['autocomplete' => 'off']], 'test_api_endpoint' => ['title' => \__('Test API Endpoint', 'cawl-for-woocommerce'), 'type' => 'text', 'default' => $defaultTestEndpoint, 'description' => \__('Enter Endpoint URL configured on your test account.', 'cawl-for-woocommerce'), 'desc_tip' => \true], 'live_api_key' => ['title' => \__('Live API Key', 'cawl-for-woocommerce'), 'type' => 'text', 'description' => \__('Find/create the API Key in Developer tab > Payment API on your CAWL Merchant Portal Dashboard.', 'cawl-for-woocommerce'), 'desc_tip' => \true, 'custom_attributes' => ['autocomplete' => 'off']], 'live_api_secret' => ['title' => \__('Live API Secret', 'cawl-for-woocommerce'), 'type' => 'password', 'description' => \__('Find/create the API Secret in Developer tab > Payment API on your CAWL Merchant Portal Dashboard.', 'cawl-for-woocommerce'), 'desc_tip' => \true, 'custom_attributes' => ['autocomplete' => 'off']], 'live_api_endpoint' => ['title' => \__('Live API Endpoint', 'cawl-for-woocommerce'), 'type' => 'text', 'default' => $defaultLiveEndpoint, 'description' => \__('Enter Endpoint URL configured on your live account.', 'cawl-for-woocommerce'), 'desc_tip' => \true]];
    $otherFields = ['debug_logging' => ['title' => \__('Advanced logging', 'cawl-for-woocommerce'), 'type' => 'checkbox', 'label' => \__('Enable debug logging', 'cawl-for-woocommerce'), 'default' => 'no', 'desc_tip' => \true, 'description' => \__('Write more details into the logs, such as HTTP requests.', 'cawl-for-woocommerce')]];
    $checkoutFields = ['checkout_behavior_title' => ['title' => \__('Checkout appearance', 'cawl-for-woocommerce'), 'type' => 'title'], 'primary_gateway_title' => ['title' => \__('Primary gateway title', 'cawl-for-woocommerce'), 'type' => 'text', 'description' => \__('Personalize the CAWL payment method title on checkout page.', 'cawl-for-woocommerce'), 'placeholder' => \__($config['GATEWAY_TITLE_DEFAULT'], 'cawl-for-woocommerce'), 'desc_tip' => \true], 'payment_button_title' => ['title' => \__('Payment button title', 'cawl-for-woocommerce'), 'type' => 'text', 'description' => \__('Personalize the Checkout Button text.', 'cawl-for-woocommerce'), 'desc_tip' => \true], 'card_brands_display' => ['title' => \__('Grouped Cards', 'cawl-for-woocommerce'), 'label' => \__('Enable card grouping', 'cawl-for-woocommerce'), 'type' => 'checkbox', 'default' => 'no'], 'stored_card_buttons' => ['title' => \__('Show tokenized cards', 'cawl-for-woocommerce'), 'type' => 'checkbox', 'label' => \__('Enable', 'cawl-for-woocommerce'), 'description' => \__('When a customer has stored cards, additional "Pay with your stored card ..." buttons will be displayed in checkout.', 'cawl-for-woocommerce'), 'desc_tip' => \true, 'default' => 'yes'], 'hosted_checkout_page_template' => ['title' => \__('Hosted checkout page template', 'cawl-for-woocommerce'), 'type' => 'text', 'description' => \__('Leave it empty for the default template.', 'cawl-for-woocommerce'), 'desc_tip' => \true, 'default' => 'SimplifiedCustomPaymentPage'], 'hosted_tokenization_page_template' => ['title' => \__('Hosted tokenization page template', 'cawl-for-woocommerce'), 'type' => 'text', 'description' => \__('Leave it empty for the default template.', 'cawl-for-woocommerce'), 'desc_tip' => \true], 'logo' => ['title' => \__('Generic logo displayed on your payment page', 'cawl-for-woocommerce') . ' <span class="woocommerce-help-tip" data-tip="' . \esc_attr__('You can upload here a new logo (file types accepted for logos are: .png .gif .jpg only). We recommend that you use images with 20px height & 120px length maximum', 'cawl-for-woocommerce') . '"></span>', 'type' => 'content', 'description' => '
                    <div class="wlop-logo-wrapper">
                        <div class="wlop-logo-preview-container">
                            <img class="wlop-logo-preview" data-default-url="' . \esc_url($defaultLogoUrl) . '" src="" alt="CAWL Logo" style="height: 40px; max-width: 120px; aspect-ratio: auto; margin-bottom: 10px;">
                        </div>
                        <div class="wlop-logo-controls">
                            <button type="button" class="button button-secondary wlop-logo-upload-button">
                                ' . \__('Upload', 'cawl-for-woocommerce') . '
                            </button>
                            <button type="button" class="button button-secondary wlop-logo-delete">
                                ' . \__('Delete', 'cawl-for-woocommerce') . '
                            </button>
                        </div>
                    </div>
                '], 'logo_url' => ['title' => '', 'type' => 'hidden', 'description' => '']];
    $surchargeFields = ['surcharge_title' => ['title' => \__('Surcharge Settings (For merchants in Australia)', 'cawl-for-woocommerce'), 'type' => 'title'], 'surcharge_enable' => ['title' => \__('Surcharge', 'cawl-for-woocommerce'), 'type' => 'checkbox', 'label' => \__('Enable', 'cawl-for-woocommerce'), 'description' => \__('Instruct the payment platform to calculate and apply a surcharge amount to a transaction, based on the merchant’s surcharge configuration, net amount, and payment product type.', 'cawl-for-woocommerce') . '<br>' . \__('Please make sure that Surcharging is active on your CAWL account. If it is not configured properly, the payments will not be processed.', 'cawl-for-woocommerce')]];
    $advancedFields = ['advanced_title' => ['title' => \__('Advanced settings', 'cawl-for-woocommerce'), 'type' => 'title'], 'authorization_mode' => ['title' => \__('Authorization mode', 'cawl-for-woocommerce'), 'type' => 'select', 'default' => 'authorization', 'options' => ['authorization' => \__('Authorization', 'cawl-for-woocommerce'), 'sale' => \__('Sale', 'cawl-for-woocommerce')], 'description' => \__('Define whether you want to process payments in one step (money captured directly; SALE) or in two steps (authorization followed by a capture; AUTHORIZATION).', 'cawl-for-woocommerce'), 'desc_tip' => \true], 'credit_card_authorization_mode' => ['title' => \__('Authorization mode for credit cards', 'cawl-for-woocommerce'), 'type' => 'select', 'default' => 'final_authorization', 'options' => ['final_authorization' => \__('Final authorization', 'cawl-for-woocommerce'), 'pre_authorization' => \__('Pre-authorization', 'cawl-for-woocommerce')], 'description' => \__("Use authorization to block customer funds for a period of 7 days. These funds cannot be reversed and must be captured for the full amount. Use pre-authorization to block the funds of your customers for a period of 30 days. The amount captured can be lower than the authorized amount. Note that all acquirers and activity sectors do not support preauthorizations.", 'cawl-for-woocommerce'), 'desc_tip' => \true], 'capture_mode' => ['title' => \__('Capture mode', 'cawl-for-woocommerce'), 'type' => 'select', 'default' => 'manual', 'options' => [CaptureMode::MANUAL => \__('Manual', 'cawl-for-woocommerce'), CaptureMode::END_OF_DAY => \__('At the end of the day', 'cawl-for-woocommerce'), CaptureMode::AFTER_1D => \__('After 1 day', 'cawl-for-woocommerce'), CaptureMode::AFTER_2D => \__('After 2 days', 'cawl-for-woocommerce'), CaptureMode::AFTER_3D => \__('After 3 days', 'cawl-for-woocommerce'), CaptureMode::AFTER_4D => \__('After 4 days', 'cawl-for-woocommerce'), CaptureMode::AFTER_5D => \__('After 5 days', 'cawl-for-woocommerce'), CaptureMode::AFTER_6D => \__('After 6 days', 'cawl-for-woocommerce'), CaptureMode::AFTER_7D => \__('After 7 days', 'cawl-for-woocommerce')], 'description' => \__('Allows to automatically capture orders after the specified time, using the Woo Action Scheduler. Depending on the Action Scheduler/WP Cron setup, sometimes captures may be delayed if the site does not receive traffic during that period.', 'cawl-for-woocommerce'), 'desc_tip' => \true], 'fixed_soft_descriptor' => ['title' => \__('Fixed soft descriptor', 'cawl-for-woocommerce'), 'type' => 'text', 'description' => \__("Minimum 2, maximum 15 characters. You can specify a fixed value that will be sent to the banks handling the payment. \nIf the consumer's bank supports it, this value may appear on the bank statement. \nImportant: this field must be filled in to use the Pledg payment method.", 'cawl-for-woocommerce'), 'desc_tip' => \true, 'custom_attributes' => ['maxlength' => 15, 'minlength' => 2]], 'automatic_cancellation_hours' => ['title' => \__('Automatic cancellation', 'cawl-for-woocommerce'), 'type' => 'select', 'default' => CancellationIntervals::DISABLED, 'options' => [CancellationIntervals::DISABLED => \__('Disabled', 'cawl-for-woocommerce'), CancellationIntervals::ONE_HOUR => \__('In 1 hour', 'cawl-for-woocommerce'), CancellationIntervals::THREE_HOURS => \__('In 3 hours', 'cawl-for-woocommerce'), CancellationIntervals::SIX_HOURS => \__('In 6 hours', 'cawl-for-woocommerce'), CancellationIntervals::TWELVE_HOURS => \__('In 12 hours', 'cawl-for-woocommerce'), CancellationIntervals::EIGHTEEN_HOURS => \__('In 18 hours', 'cawl-for-woocommerce'), CancellationIntervals::ONE_DAY => \__('In 24 hours', 'cawl-for-woocommerce'), CancellationIntervals::TWO_DAYS => \__('In 2 days', 'cawl-for-woocommerce'), CancellationIntervals::THREE_DAYS => \__('In 3 days', 'cawl-for-woocommerce')], 'description' => \__('Set up automatic cancellation of pending orders. The selected value defines after how many hours orders in Pending payment status will be cancelled. For example, if 3 hours is selected, all pending orders older than 3 hours will be automatically cancelled. This depends on the website activity since it relies on the WordPress cron.', 'cawl-for-woocommerce'), 'desc_tip' => \true], 'enable_3ds' => ['title' => \__('3-D Secure authentication', 'cawl-for-woocommerce'), 'type' => 'checkbox', 'label' => \__('Enable', 'cawl-for-woocommerce'), 'default' => 'yes', 'description' => \__('Enforce 3DS for all transactions.', 'cawl-for-woocommerce'), 'desc_tip' => \true], 'enforce_3dsv2' => ['title' => \__('Enforce 3DS challenge', 'cawl-for-woocommerce'), 'type' => 'checkbox', 'label' => \__('Enable', 'cawl-for-woocommerce'), 'default' => 'no', 'description' => \__('Enforce strong customer authentication for all transactions.', 'cawl-for-woocommerce'), 'desc_tip' => \true], 'request_3ds_exemption' => [
        'title' => \__('Exempt transactions from 3DS', 'cawl-for-woocommerce'),
        'type' => 'checkbox',
        'label' => \__('Enable', 'cawl-for-woocommerce'),
        'default' => 'no',
        /*
         * translators: %1$s - newlines
         */
        'description' => \sprintf(\__('By enabling the 3DS Exemption, you allow the card issuer and your acquirer to evaluate the risk level of transactions up to the Exemption Limit you specify in EUR. If the criteria are met, your customers will be exempt from Strong Customer Authentication (SCA).
%1$s
If your acquirer rejects the exemption and requires SCA, this is referred to as a soft decline. In such cases, we will attempt to prompt the customer for SCA and reinitiate the transaction if the customer successfully authenticates.', 'cawl-for-woocommerce'), '<br/></br>'),
        'desc_tip' => \true,
    ], '3ds_exemption_warning' => ['type' => 'content', 'render_directly' => \true, 'description' => '<div class="wlop-warning-field">' . \__('Please be aware that if fraud occurs on a transaction that has been granted an exemption, the liability falls on the merchant!', 'cawl-for-woocommerce') . '</div>'], '3ds_exemption_type' => [
        'title' => \__('Exemption type', 'cawl-for-woocommerce'),
        'type' => 'select',
        'default' => ExemptionType::LOW_VALUE,
        'options' => [ExemptionType::LOW_VALUE => \__('Low-Value', 'cawl-for-woocommerce'), ExemptionType::TRA => \__('Transaction-Risk-Analysis', 'cawl-for-woocommerce')],
        /*
         * translators: %1$s - newlines
         */
        'description' => \sprintf(\__('The Low-Value exemption is suitable for transactions below the specified monetary threshold of 30 EUR, allowing these low-value transactions to bypass Strong Customer Authentication (SCA) and streamline the checkout process.
%1$s
On the other hand, the Transaction-Risk-Analysis exemption enables a dynamic risk assessment for your transactions. The card issuer will evaluate the transaction based on various risk factors, allowing transactions up to a limit of 100 EUR to qualify for exemption if they are deemed low risk.
%1$s
Make your selection carefully to optimize the balance between customer experience and security for your transactions.', 'cawl-for-woocommerce'), '<br/></br>'),
        'desc_tip' => \true,
    ], '3ds_exemption_limit' => [
        'title' => \__('Exemption limit', 'cawl-for-woocommerce'),
        'type' => 'number',
        'default' => 30,
        'custom_attributes' => ['min' => 0, 'max' => 30],
        /*
         * translators: %1$s - newlines
         */
        'description' => \sprintf(\__('The exemption limit is specified in EUR. Therefore, if the checkout currency is not in EUR, the conversion will depend on the exchange rate to EUR. It is essential to have EUR configured in your environment, and to ensure accurate conversions, please keep your exchange rates updated.
%1$s
If EUR is not configured, the 3DS exemption will not be applied, and the transaction will not have the exemption requested.
%1$s
Additional Note: PSD2 designates the EUR as the base currency for determining exemption limits for other currencies in the EEA. However, each region can decide to adapt these limits, and regions outside the EEA may also support exemption requests. Due to these complexities, we cannot guarantee that the exemption request will be considered by the issuer or your acquirer.', 'cawl-for-woocommerce'), '<br/></br>'),
        'desc_tip' => \true,
    ], 'send_shopping_cart' => ['title' => \__('Send shopping cart', 'cawl-for-woocommerce'), 'type' => 'checkbox', 'label' => \__('Enable cart data submission.', 'cawl-for-woocommerce'), 'default' => 'yes', 'description' => \__('When enabled, the shopping cart details will be included in the API request.', 'cawl-for-woocommerce'), 'desc_tip' => \true], 'clear_data_on_uninstall' => ['title' => \__('Clear data on uninstall', 'cawl-for-woocommerce'), 'type' => 'checkbox', 'label' => \sprintf(
        /* translators: %s is a link for "Clear now" */
        \__('Delete plugin data from the database upon uninstallation. %s', 'cawl-for-woocommerce'),
        \sprintf('<a href="%s">%s</a>', \esc_url($dbCleanerUrl), \__('(Click here to reset the data now)', 'cawl-for-woocommerce'))
    ), 'default' => 'no']];
    return \array_merge(['enabled' => ['title' => \__('Enable/Disable', 'cawl-for-woocommerce'), 'type' => 'checkbox', 'label' => \__('Enable CAWL for WooCommerce', 'cawl-for-woocommerce'), 'default' => 'no']], $apiFields, $webhookFields, $otherFields, $checkoutFields, $surchargeFields, $advancedFields);
});
