<?php

declare (strict_types=1);
namespace Syde\Vendor\Cawl;

// phpcs:disable Inpsyde.CodeQuality.LineLength.TooLong
use Syde\Vendor\Cawl\Dhii\Services\Factories\Alias;
use Syde\Vendor\Cawl\Dhii\Services\Factories\Constructor;
use Syde\Vendor\Cawl\Dhii\Services\Factory;
use Syde\Vendor\Cawl\Dhii\Services\Service;
use Syde\Vendor\Cawl\Inpsyde\PaymentGateway\DefaultIconsRenderer;
use Syde\Vendor\Cawl\Inpsyde\PaymentGateway\Icon;
use Syde\Vendor\Cawl\Inpsyde\PaymentGateway\IconProviderInterface;
use Syde\Vendor\Cawl\Inpsyde\PaymentGateway\StaticIconProvider;
use Syde\Vendor\Cawl\Inpsyde\WorldlineForWoocommerce\CVCOGateway\CVCOGatewayModule;
use Syde\Vendor\Cawl\Inpsyde\WorldlineForWoocommerce\CVCOGateway\Payment\CVCORequestModifier;
use Syde\Vendor\Cawl\Inpsyde\WorldlineForWoocommerce\Vaulting\WcTokenRepository;
use Syde\Vendor\Cawl\Inpsyde\WorldlineForWoocommerce\WorldlinePaymentGateway\Api\HostedCheckoutUrlFactory;
use Syde\Vendor\Cawl\Inpsyde\WorldlineForWoocommerce\WorldlinePaymentGateway\Api\WcOrderBasedOrderFactoryInterface;
use Syde\Vendor\Cawl\Inpsyde\WorldlineForWoocommerce\WorldlinePaymentGateway\GatewayIds;
use Syde\Vendor\Cawl\Inpsyde\WorldlineForWoocommerce\WorldlinePaymentGateway\Payment\HostedPaymentProcessor;
use Syde\Vendor\Cawl\Psr\Container\ContainerInterface;
return static function () : array {
    $moduleRoot = \dirname(__FILE__, 2);
    $gatewayId = GatewayIds::CVCO;
    return ["payment_gateway.{$gatewayId}.form_fields" => Service::fromFile("{$moduleRoot}/inc/fields.php"), "payment_gateway.{$gatewayId}.method_title" => static fn(): string => \__('Cheque Vacances Connect (CAWL)', 'cawl-for-woocommerce'), "payment_gateway.{$gatewayId}.title" => static fn() => \__('Cheque Vacances Connect', 'cawl-for-woocommerce'), "payment_gateway.{$gatewayId}.method_description" => static fn(): string => \__('Accept payments with Cheque Vacances Connect.', 'cawl-for-woocommerce'), "payment_gateway.{$gatewayId}.description" => static fn(): string => '', "payment_gateway.{$gatewayId}.order_button_text" => static fn(): ?string => null, "payment_gateway.{$gatewayId}.payment_request_validator" => new Alias('payment_gateways.noop_payment_request_validator'), "payment_gateway.{$gatewayId}.payment_processor" => new Factory(['worldline_payment_gateway.hosted_checkout_url_factory', 'worldline_payment_gateway.wc_order_factory', 'vaulting.repository.wc.tokens.' . GatewayIds::HOSTED_CHECKOUT, 'worldline_payment_gateway.hosted_checkout_language', 'cvco.request_modifier'], static function (HostedCheckoutUrlFactory $hostedCheckoutUrlFactory, WcOrderBasedOrderFactoryInterface $wcOrderBasedOrderFactory, WcTokenRepository $wcTokenRepository, ?string $hostedCheckoutLanguage, CVCORequestModifier $CVCORequestModifier) : HostedPaymentProcessor {
        return new HostedPaymentProcessor($hostedCheckoutUrlFactory, $wcOrderBasedOrderFactory, $wcTokenRepository, $hostedCheckoutLanguage, $CVCORequestModifier);
    }), "payment_gateway.{$gatewayId}.supports" => static function () : array {
        return ['products', 'refunds'];
    }, "payment_gateway.{$gatewayId}.refund_processor" => new Alias('payment_gateway.' . GatewayIds::HOSTED_CHECKOUT . '.refund_processor'), "payment_gateway.{$gatewayId}.availability_callback" => static function (ContainerInterface $container) : callable {
        return static function () use($container) : bool {
            try {
                $wcOrder = null;
                if (\is_wc_endpoint_url('order-pay')) {
                    global $wp;
                    if (isset($wp->query_vars['order-pay']) && \is_numeric($wp->query_vars['order-pay'])) {
                        $wcOrder = \wc_get_order(\absint($wp->query_vars['order-pay']));
                    }
                }
                // When order is created
                if ($wcOrder instanceof \WC_Order) {
                    $customer_email = $wcOrder->get_billing_email();
                    $customer_id = $wcOrder->get_customer_id();
                }
                // When order is not yet created
                if (!$wcOrder instanceof \WC_Order) {
                    if (!\WC()->cart || \count(\WC()->cart->get_cart()) === 0) {
                        return \false;
                    }
                    $customer_email = \WC()->customer ? \WC()->customer->get_email() : '';
                    $customer_id = \WC()->customer ? \WC()->customer->get_id() : 0;
                }
                return !empty($customer_email) && !empty($customer_id);
            } catch (\Throwable $exception) {
                return \false;
            }
        };
    }, "payment_gateway.{$gatewayId}.method_icon_provider" => new Factory(['assets.get_module_static_asset_url'], static function (callable $getStaticAssetUrl) : IconProviderInterface {
        /** @var string $src */
        $src = $getStaticAssetUrl(CVCOGatewayModule::PACKAGE_NAME, "images/cvco-logo.svg");
        $icon = new Icon('cvco-logo', $src, 'CVCO logo');
        return new StaticIconProvider($icon);
    }), "payment_gateway.{$gatewayId}.gateway_icons_renderer" => new Constructor(DefaultIconsRenderer::class, ["payment_gateway.{$gatewayId}.method_icon_provider"]), "cvco.request_modifier" => new Constructor(CVCORequestModifier::class, [])];
};
