<?php

declare (strict_types=1);
namespace Syde\Vendor\Cawl;

use Syde\Vendor\Cawl\Dhii\Services\Factory;
use Syde\Vendor\Cawl\Psr\Http\Message\UriInterface;
return new Factory(['webhooks.notification_url'], static function (?UriInterface $notificationUrl) : array {
    $staticWebhookModeTooltip = \sprintf(\__('Webhooks are the primary method your store uses to receive real-time payment notifications (e.g., paid, failed, refunded), which are essential for creating and updating your orders. Automatic Mode Explained: The plugin automatically sends the store webhook URL with every payment request, which is the safest and most reliable option. This mode also allows you to add up to 4 additional URLs to send notifications to external services, like accounting or subscription management. Please be aware that in this mode, any webhook URLs configured in your merchant portal will be ignored for transactions originating from this specific store. Manual Mode Explained: You will be required to manually copy the Store Webhook URL and paste it into your merchant portal\'s webhook configuration. Crucially for multistore users, this URL is unique for each store, and this process must be repeated for every single one.', 'cawl-for-woocommerce'));
    $settings = \get_option('woocommerce_cawl-for-woocommerce_settings', []);
    $isUpgrade = !empty($settings) && !isset($settings['webhook_mode_is_automatic']);
    $webhookModeDefault = $isUpgrade ? 'no' : 'yes';
    return ['test_webhook_id' => ['title' => \__('Test Webhook ID', 'cawl-for-woocommerce'), 'type' => 'text', 'desc_tip' => \true, 'description' => \__('Find/create the Webhook Key in the Developer tab > Webhooks on your CAWL Merchant Portal Dashboard.', 'cawl-for-woocommerce'), 'custom_attributes' => ['autocomplete' => 'off']], 'test_webhook_secret_key' => ['title' => \__('Test Secret webhook key', 'cawl-for-woocommerce'), 'type' => 'password', 'desc_tip' => \true, 'description' => \__('Find/create the Webhook Secret in the Developer tab > Webhooks on your CAWL Merchant Portal Dashboard.', 'cawl-for-woocommerce')], 'live_webhook_id' => ['title' => \__('Live Webhook ID', 'cawl-for-woocommerce'), 'type' => 'text', 'desc_tip' => \true, 'description' => \__('Find/create the Webhook Key in the Developer tab > Webhooks on your CAWL Merchant Portal Dashboard.', 'cawl-for-woocommerce'), 'custom_attributes' => ['autocomplete' => 'off']], 'live_webhook_secret_key' => ['title' => \__('Live Secret webhook key', 'cawl-for-woocommerce'), 'type' => 'password', 'desc_tip' => \true, 'description' => \__('Find/create the Webhook Secret in the Developer tab > Webhooks on your CAWL Merchant Portal Dashboard.', 'cawl-for-woocommerce')], 'webhook_mode_is_automatic' => ['title' => \__('Webhook URL Configuration', 'cawl-for-woocommerce'), 'type' => 'checkbox', 'label' => \__('Automatic (Recommended)', 'cawl-for-woocommerce'), 'default' => $webhookModeDefault, 'desc_tip' => \true, 'description' => $staticWebhookModeTooltip], 'webhook_mode_warning' => ['type' => 'content', 'render_directly' => \true, 'description' => '<div id="wlop-webhook-mode-warning" class="wlop-warning-field"></div>'], 'webhook_endpoint_url' => ['title' => \__('Store Webhook URL', 'cawl-for-woocommerce'), 'type' => 'text', 'save' => \false, 'default' => (string) $notificationUrl, 'description' => '
                <button type="button" 
                    data-copy="
                    #woocommerce_cawl-for-woocommerce_webhook_endpoint_url
                    " 
                    data-copied-message="' . \__('Copied to clipboard', 'cawl-for-woocommerce') . '"
                    class="button-primary wlop-button-copy wlop-manual-mode-only">' . \__('Copy', 'cawl-for-woocommerce') . '</button>', 'desc_tip' => \false, 'custom_attributes' => ['readonly' => 'readonly']], 'additional_webhook_url_1' => ['title' => \__('Additional Webhook URLs', 'cawl-for-woocommerce'), 'type' => 'text', 'placeholder' => \__('Optional', 'cawl-for-woocommerce'), 'class' => 'wlop-additional-webhook-field', 'desc_tip' => \true, 'description' => \__('Specify up to four additional URLs to receive a copy of every webhook event. This is an advanced feature for synchronizing payment data across multiple platforms (e.g., accounting software, fulfillment services). Each URL must be a valid and accessible HTTPS URL capable of receiving POST requests.', 'cawl-for-woocommerce'), 'custom_attributes' => ['maxlength' => '325']], 'additional_webhook_url_2' => ['title' => '', 'type' => 'text', 'placeholder' => \__('Optional', 'cawl-for-woocommerce'), 'class' => 'wlop-additional-webhook-field', 'desc_tip' => \true, 'description' => '', 'custom_attributes' => ['maxlength' => '325']], 'additional_webhook_url_3' => ['title' => '', 'type' => 'text', 'placeholder' => \__('Optional', 'cawl-for-woocommerce'), 'class' => 'wlop-additional-webhook-field', 'desc_tip' => \true, 'description' => '', 'custom_attributes' => ['maxlength' => '325']], 'additional_webhook_url_4' => ['title' => '', 'type' => 'text', 'placeholder' => \__('Optional', 'cawl-for-woocommerce'), 'class' => 'wlop-additional-webhook-field', 'desc_tip' => \false, 'description' => \__('You can add up to 4 additional webhook URLs', 'cawl-for-woocommerce'), 'custom_attributes' => ['maxlength' => '325']]];
});
