<?php

/*
 * This file was automatically generated.
 */
namespace Syde\Vendor\Cawl\OnlinePayments\Sdk\Domain;

use UnexpectedValueException;
/**
 * @package OnlinePayments\Sdk\Domain
 */
class CardPayoutMethodSpecificInput extends DataObject
{
    /**
     * @var Card
     */
    public $card = null;
    /**
     * @var int
     */
    public $paymentProductId = null;
    /**
     * @var string
     */
    public $payoutReason = null;
    /**
     * @var string
     */
    public $token = null;
    /**
     * @return Card
     */
    public function getCard()
    {
        return $this->card;
    }
    /**
     * @param Card
     */
    public function setCard($value)
    {
        $this->card = $value;
    }
    /**
     * @return int
     */
    public function getPaymentProductId()
    {
        return $this->paymentProductId;
    }
    /**
     * @param int
     */
    public function setPaymentProductId($value)
    {
        $this->paymentProductId = $value;
    }
    /**
     * @return string
     */
    public function getPayoutReason()
    {
        return $this->payoutReason;
    }
    /**
     * @param string
     */
    public function setPayoutReason($value)
    {
        $this->payoutReason = $value;
    }
    /**
     * @return string
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * @param string
     */
    public function setToken($value)
    {
        $this->token = $value;
    }
    /**
     * @return object
     */
    public function toObject()
    {
        $object = parent::toObject();
        if (!\is_null($this->card)) {
            $object->card = $this->card->toObject();
        }
        if (!\is_null($this->paymentProductId)) {
            $object->paymentProductId = $this->paymentProductId;
        }
        if (!\is_null($this->payoutReason)) {
            $object->payoutReason = $this->payoutReason;
        }
        if (!\is_null($this->token)) {
            $object->token = $this->token;
        }
        return $object;
    }
    /**
     * @param object $object
     * @return $this
     * @throws UnexpectedValueException
     */
    public function fromObject($object)
    {
        parent::fromObject($object);
        if (\property_exists($object, 'card')) {
            if (!\is_object($object->card)) {
                throw new UnexpectedValueException('value \'' . \print_r($object->card, \true) . '\' is not an object');
            }
            $value = new Card();
            $this->card = $value->fromObject($object->card);
        }
        if (\property_exists($object, 'paymentProductId')) {
            $this->paymentProductId = $object->paymentProductId;
        }
        if (\property_exists($object, 'payoutReason')) {
            $this->payoutReason = $object->payoutReason;
        }
        if (\property_exists($object, 'token')) {
            $this->token = $object->token;
        }
        return $this;
    }
}
